;---------------------------------------------------------------------------------------------------
;
; name:			idlcr8.pro
; description: 	Wrapper for idlcr8 hdf/ascii tools
;
; 2011-03-31, v1.0	Christian Retscher	initial implementation
;
;---------------------------------------------------------------------------------------------------

;---------------------------------------------------------------------------------------------------
function is_a_number,value
	on_ioerror, ConversionError
	n=DOUBLE(value)
	return,1B
	ConversionError:
	return, 0B
END

;---------------------------------------------------------------------------------------------------
PRO idlcr8

	args = command_line_args() 
	iNrArgs = size(args, /N_ELEMENTS)
	
	if ( iNrArgs ne 3 ) and ( iNrArgs ne 5 ) then begin
		print
		print, 'Idlcr8 suite'
		print, '  Release v4.01, 2011-03-31'
		print, '  Converts from and to HDF4/5 and ASCII data.'
		print
		print, 'usage: idl -rt=idlcr8.sav -args [OUTPUTDIR] [OUTPUTFORMAT] [INPUTDATA1] [[INPUTDATA2]] [[TAVFILE]]'
		print
		print, '1: OUTPUTDIR is the path of the output directory of the harmonized file' 
		print, '2: OUTPUTFORMAT: 0: HDF4' 
		print, '                 1: HDF5' 
		print, '                 2: ASCII' 
		print, '3: INPUTDATA1 is the path to an HDF4/5 file or path to ASCII metadata file'
		print, '4: Required, if option 3 = [0|1]. INPUTDATA2 is the path to ASCII data file'
		print, '5: Required, if option 3 = [0|1]. TAVFILE is the path of the TAV file, you want to use' 
		print, '------------------------------------------------------------------------------------------------'
		print
		
		idlcr8_error_code = 3
		exit, status=idlcr8_error_code
	end	

	idlcr8_error_code = 0

	chDirOutput 		= STRTRIM(args(0), 2)
	iDataType 		    = STRTRIM(args(1), 2)
	chInputData1  		= STRTRIM(args(2), 2)
	
	; check for five arguments
	if ( iNrArgs eq 5 ) then begin
		chInputData2	= STRTRIM(args(3), 2)
		chFileTAV		= STRTRIM(args(4), 2)
	
		if ( file_test( chInputData2 ) eq 0 ) then begin
			idlcr8_error_code = 3
			print, 'ERROR: INPUTDATA2 not found.'
		end		

		if ( file_test( chFileTAV ) eq 0 ) then begin
			idlcr8_error_code = 3
			print, 'ERROR: TAV file not found.'
		end		
	end	
	
	; check if option 3 is numeric
	if is_a_number( iDataType ) then begin
		; check if option 3 is [0|1|2]
		if ( iDataType ge 0 ) and ( iDataType le 2 ) then begin
			; check if fiths arguments is valid
			if ( iDataType eq 0 ) or ( iDataType eq 1 ) then begin
				if ( iNrArgs eq 5 ) then begin
					print, 'idlcr8hdf'
					iProgram = 0
				endif else begin
					idlcr8_error_code = 3
					print, 'ERROR: For HDF4/5 output you must provide one ASCII metadata and one ASCII data file, as well as one TAV file.'
				end	
			end	
			if ( iDataType eq 2 ) then begin
				print, 'idlcr8ascii'
				iProgram = 1
			end	
		endif else begin
			idlcr8_error_code = 3
			print, 'ERROR: Option 3 must be [0|1|2].'
		end
	endif else begin
		idlcr8_error_code = 3
		print, 'ERROR: Option 3 must be numeric [0|1|2].'
	end	
	
	if ( file_test( chDirOutput ) eq 0 ) then begin
		idlcr8_error_code = 3
		print, 'ERROR: Output directory not found.'
	end		

	if ( file_test( chInputData1 ) eq 0 ) then begin
		idlcr8_error_code = 3
		print, 'ERROR: INPUTDATA1 not found.'
	end		

	; process data
	if ( idlcr8_error_code eq 0 ) then begin
		if ( iProgram eq 0 ) then begin
			reterr = ''
			
			if ( iDataType ge 0 ) then begin
				idlcr8hdf, chInputData1, chInputData2, chFileTAV, chDirOutput, reterr, /LOG
			end	
			if ( iDataType ge 1 ) then begin
				idlcr8hdf, chInputData1, chInputData2, chFileTAV, chDirOutput, reterr, /LOG, /h5
			end	
		end
		if ( iProgram eq 1 ) then begin
			reterr=''
			idlcr8ascii, chInputData1, reterr, /FORMAT
			
			chInputData1Dir = file_dirname( chInputData1 )
			chInputData1File = file_basename( chInputData1 )

;			iInputData1Pos = STRPOS( chInputData1File, '.', /REVERSE_SEARCH )
;			chInputData1Split = STRSPLIT( chInputData1File, iInputData1Pos, /EXTRACT )
			
			chInputData1Split = STRSPLIT( chInputData1File, '.', /EXTRACT )
			iSize1 = size(chInputData1Split, /N_ELEMENTS) - 2
			chInputData1SplitJoin = STRJOIN( chInputData1Split[0:iSize1], '.' )
			
			chFileMeta = chInputData1Dir+'/'+chInputData1SplitJoin+'.meta'
			chFileData = chInputData1Dir+'/'+chInputData1SplitJoin+'.data'
			
			SPAWN, 'mv '+chFileMeta+' '+chDirOutput
			SPAWN, 'mv '+chFileData+' '+chDirOutput
			
			print, chFileMeta+' moved to '+chDirOutput
			print, chFileData+' moved to '+chDirOutput
		end
	end	
	
	exit, status=idlcr8_error_code

END
